// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> A skill that extracts content from a file within the enrichment pipeline. </summary>
    public partial class DocumentExtractionSkill : SearchIndexerSkill
    {
        /// <summary> Initializes a new instance of <see cref="DocumentExtractionSkill"/>. </summary>
        /// <param name="inputs"> Inputs of the skills could be a column in the source data set, or the output of an upstream skill. </param>
        /// <param name="outputs"> The output of a skill is either a field in a search index, or a value that can be consumed as an input by another skill. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="inputs"/> or <paramref name="outputs"/> is null. </exception>
        public DocumentExtractionSkill(IEnumerable<InputFieldMappingEntry> inputs, IEnumerable<OutputFieldMappingEntry> outputs) : base(inputs, outputs)
        {
            Argument.AssertNotNull(inputs, nameof(inputs));
            Argument.AssertNotNull(outputs, nameof(outputs));

            Configuration = new ChangeTrackingDictionary<string, object>();
            ODataType = "#Microsoft.Skills.Util.DocumentExtractionSkill";
        }

        /// <summary> Initializes a new instance of <see cref="DocumentExtractionSkill"/>. </summary>
        /// <param name="oDataType"> A URI fragment specifying the type of skill. </param>
        /// <param name="name"> The name of the skill which uniquely identifies it within the skillset. A skill with no name defined will be given a default name of its 1-based index in the skills array, prefixed with the character '#'. </param>
        /// <param name="description"> The description of the skill which describes the inputs, outputs, and usage of the skill. </param>
        /// <param name="context"> Represents the level at which operations take place, such as the document root or document content (for example, /document or /document/content). The default is /document. </param>
        /// <param name="inputs"> Inputs of the skills could be a column in the source data set, or the output of an upstream skill. </param>
        /// <param name="outputs"> The output of a skill is either a field in a search index, or a value that can be consumed as an input by another skill. </param>
        /// <param name="parsingMode"> The parsingMode for the skill. Will be set to 'default' if not defined. </param>
        /// <param name="dataToExtract"> The type of data to be extracted for the skill. Will be set to 'contentAndMetadata' if not defined. </param>
        /// <param name="configuration"> A dictionary of configurations for the skill. </param>
        internal DocumentExtractionSkill(string oDataType, string name, string description, string context, IList<InputFieldMappingEntry> inputs, IList<OutputFieldMappingEntry> outputs, BlobIndexerParsingMode? parsingMode, BlobIndexerDataToExtract? dataToExtract, IDictionary<string, object> configuration) : base(oDataType, name, description, context, inputs, outputs)
        {
            ParsingMode = parsingMode;
            DataToExtract = dataToExtract;
            Configuration = configuration;
            ODataType = oDataType ?? "#Microsoft.Skills.Util.DocumentExtractionSkill";
        }
    }
}
