// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class DocumentDebugInfo
    {
        internal static DocumentDebugInfo DeserializeDocumentDebugInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SemanticDebugInfo semantic = default;
            VectorsDebugInfo vectors = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("semantic"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    semantic = SemanticDebugInfo.DeserializeSemanticDebugInfo(property.Value);
                    continue;
                }
                if (property.NameEquals("vectors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vectors = VectorsDebugInfo.DeserializeVectorsDebugInfo(property.Value);
                    continue;
                }
            }
            return new DocumentDebugInfo(semantic, vectors);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DocumentDebugInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDocumentDebugInfo(document.RootElement);
        }
    }
}
