// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Represents credentials that can be used to connect to a datasource. </summary>
    internal partial class DataSourceCredentials
    {
        /// <summary> Initializes a new instance of <see cref="DataSourceCredentials"/>. </summary>
        public DataSourceCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataSourceCredentials"/>. </summary>
        /// <param name="connectionString"> The connection string for the datasource. Set to `&lt;unchanged&gt;` (with brackets) if you don't want the connection string updated. Set to `&lt;redacted&gt;` if you want to remove the connection string value from the datasource. </param>
        internal DataSourceCredentials(string connectionString)
        {
            ConnectionString = connectionString;
        }

        /// <summary> The connection string for the datasource. Set to `&lt;unchanged&gt;` (with brackets) if you don't want the connection string updated. Set to `&lt;redacted&gt;` if you want to remove the connection string value from the datasource. </summary>
        public string ConnectionString { get; set; }
    }
}
