// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary>
    /// Base type for data change detection policies.
    /// Please note <see cref="DataChangeDetectionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="HighWaterMarkChangeDetectionPolicy"/> and <see cref="SqlIntegratedChangeTrackingPolicy"/>.
    /// </summary>
    public partial class DataChangeDetectionPolicy
    {
        /// <summary> Initializes a new instance of <see cref="DataChangeDetectionPolicy"/>. </summary>
        /// <param name="oDataType"> A URI fragment specifying the type of data change detection policy. </param>
        internal DataChangeDetectionPolicy(string oDataType)
        {
            ODataType = oDataType;
        }

        /// <summary> A URI fragment specifying the type of data change detection policy. </summary>
        internal string ODataType { get; set; }
    }
}
