// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The language codes supported for input text by CustomEntityLookupSkill. </summary>
    public readonly partial struct CustomEntityLookupSkillLanguage : IEquatable<CustomEntityLookupSkillLanguage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomEntityLookupSkillLanguage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomEntityLookupSkillLanguage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DaValue = "da";
        private const string DeValue = "de";
        private const string EnValue = "en";
        private const string EsValue = "es";
        private const string FiValue = "fi";
        private const string FrValue = "fr";
        private const string ItValue = "it";
        private const string KoValue = "ko";
        private const string PtValue = "pt";

        /// <summary> Danish. </summary>
        public static CustomEntityLookupSkillLanguage Da { get; } = new CustomEntityLookupSkillLanguage(DaValue);
        /// <summary> German. </summary>
        public static CustomEntityLookupSkillLanguage De { get; } = new CustomEntityLookupSkillLanguage(DeValue);
        /// <summary> English. </summary>
        public static CustomEntityLookupSkillLanguage En { get; } = new CustomEntityLookupSkillLanguage(EnValue);
        /// <summary> Spanish. </summary>
        public static CustomEntityLookupSkillLanguage Es { get; } = new CustomEntityLookupSkillLanguage(EsValue);
        /// <summary> Finnish. </summary>
        public static CustomEntityLookupSkillLanguage Fi { get; } = new CustomEntityLookupSkillLanguage(FiValue);
        /// <summary> French. </summary>
        public static CustomEntityLookupSkillLanguage Fr { get; } = new CustomEntityLookupSkillLanguage(FrValue);
        /// <summary> Italian. </summary>
        public static CustomEntityLookupSkillLanguage It { get; } = new CustomEntityLookupSkillLanguage(ItValue);
        /// <summary> Korean. </summary>
        public static CustomEntityLookupSkillLanguage Ko { get; } = new CustomEntityLookupSkillLanguage(KoValue);
        /// <summary> Portuguese. </summary>
        public static CustomEntityLookupSkillLanguage Pt { get; } = new CustomEntityLookupSkillLanguage(PtValue);
        /// <summary> Determines if two <see cref="CustomEntityLookupSkillLanguage"/> values are the same. </summary>
        public static bool operator ==(CustomEntityLookupSkillLanguage left, CustomEntityLookupSkillLanguage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomEntityLookupSkillLanguage"/> values are not the same. </summary>
        public static bool operator !=(CustomEntityLookupSkillLanguage left, CustomEntityLookupSkillLanguage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomEntityLookupSkillLanguage"/>. </summary>
        public static implicit operator CustomEntityLookupSkillLanguage(string value) => new CustomEntityLookupSkillLanguage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomEntityLookupSkillLanguage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomEntityLookupSkillLanguage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
