// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class CustomEntityLookupSkill : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(DefaultLanguageCode))
            {
                if (DefaultLanguageCode != null)
                {
                    writer.WritePropertyName("defaultLanguageCode"u8);
                    writer.WriteStringValue(DefaultLanguageCode.Value.ToString());
                }
                else
                {
                    writer.WriteNull("defaultLanguageCode");
                }
            }
            if (Optional.IsDefined(EntitiesDefinitionUri))
            {
                if (EntitiesDefinitionUri != null)
                {
                    writer.WritePropertyName("entitiesDefinitionUri"u8);
                    writer.WriteStringValue(EntitiesDefinitionUri.AbsoluteUri);
                }
                else
                {
                    writer.WriteNull("entitiesDefinitionUri");
                }
            }
            if (Optional.IsCollectionDefined(InlineEntitiesDefinition))
            {
                if (InlineEntitiesDefinition != null)
                {
                    writer.WritePropertyName("inlineEntitiesDefinition"u8);
                    writer.WriteStartArray();
                    foreach (var item in InlineEntitiesDefinition)
                    {
                        writer.WriteObjectValue<CustomEntity>(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("inlineEntitiesDefinition");
                }
            }
            if (Optional.IsDefined(GlobalDefaultCaseSensitive))
            {
                if (GlobalDefaultCaseSensitive != null)
                {
                    writer.WritePropertyName("globalDefaultCaseSensitive"u8);
                    writer.WriteBooleanValue(GlobalDefaultCaseSensitive.Value);
                }
                else
                {
                    writer.WriteNull("globalDefaultCaseSensitive");
                }
            }
            if (Optional.IsDefined(GlobalDefaultAccentSensitive))
            {
                if (GlobalDefaultAccentSensitive != null)
                {
                    writer.WritePropertyName("globalDefaultAccentSensitive"u8);
                    writer.WriteBooleanValue(GlobalDefaultAccentSensitive.Value);
                }
                else
                {
                    writer.WriteNull("globalDefaultAccentSensitive");
                }
            }
            if (Optional.IsDefined(GlobalDefaultFuzzyEditDistance))
            {
                if (GlobalDefaultFuzzyEditDistance != null)
                {
                    writer.WritePropertyName("globalDefaultFuzzyEditDistance"u8);
                    writer.WriteNumberValue(GlobalDefaultFuzzyEditDistance.Value);
                }
                else
                {
                    writer.WriteNull("globalDefaultFuzzyEditDistance");
                }
            }
            writer.WritePropertyName("@odata.type"u8);
            writer.WriteStringValue(ODataType);
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(Context))
            {
                writer.WritePropertyName("context"u8);
                writer.WriteStringValue(Context);
            }
            writer.WritePropertyName("inputs"u8);
            writer.WriteStartArray();
            foreach (var item in Inputs)
            {
                writer.WriteObjectValue<InputFieldMappingEntry>(item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("outputs"u8);
            writer.WriteStartArray();
            foreach (var item in Outputs)
            {
                writer.WriteObjectValue<OutputFieldMappingEntry>(item);
            }
            writer.WriteEndArray();
            writer.WriteEndObject();
        }

        internal static CustomEntityLookupSkill DeserializeCustomEntityLookupSkill(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CustomEntityLookupSkillLanguage? defaultLanguageCode = default;
            Uri entitiesDefinitionUri = default;
            IList<CustomEntity> inlineEntitiesDefinition = default;
            bool? globalDefaultCaseSensitive = default;
            bool? globalDefaultAccentSensitive = default;
            int? globalDefaultFuzzyEditDistance = default;
            string odataType = default;
            string name = default;
            string description = default;
            string context = default;
            IList<InputFieldMappingEntry> inputs = default;
            IList<OutputFieldMappingEntry> outputs = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("defaultLanguageCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        defaultLanguageCode = null;
                        continue;
                    }
                    defaultLanguageCode = new CustomEntityLookupSkillLanguage(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("entitiesDefinitionUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        entitiesDefinitionUri = null;
                        continue;
                    }
                    entitiesDefinitionUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("inlineEntitiesDefinition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        inlineEntitiesDefinition = null;
                        continue;
                    }
                    List<CustomEntity> array = new List<CustomEntity>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomEntity.DeserializeCustomEntity(item));
                    }
                    inlineEntitiesDefinition = array;
                    continue;
                }
                if (property.NameEquals("globalDefaultCaseSensitive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        globalDefaultCaseSensitive = null;
                        continue;
                    }
                    globalDefaultCaseSensitive = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("globalDefaultAccentSensitive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        globalDefaultAccentSensitive = null;
                        continue;
                    }
                    globalDefaultAccentSensitive = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("globalDefaultFuzzyEditDistance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        globalDefaultFuzzyEditDistance = null;
                        continue;
                    }
                    globalDefaultFuzzyEditDistance = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    context = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inputs"u8))
                {
                    List<InputFieldMappingEntry> array = new List<InputFieldMappingEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InputFieldMappingEntry.DeserializeInputFieldMappingEntry(item));
                    }
                    inputs = array;
                    continue;
                }
                if (property.NameEquals("outputs"u8))
                {
                    List<OutputFieldMappingEntry> array = new List<OutputFieldMappingEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OutputFieldMappingEntry.DeserializeOutputFieldMappingEntry(item));
                    }
                    outputs = array;
                    continue;
                }
            }
            return new CustomEntityLookupSkill(
                odataType,
                name,
                description,
                context,
                inputs,
                outputs,
                defaultLanguageCode,
                entitiesDefinitionUri,
                inlineEntitiesDefinition ?? new ChangeTrackingList<CustomEntity>(),
                globalDefaultCaseSensitive,
                globalDefaultAccentSensitive,
                globalDefaultFuzzyEditDistance);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new CustomEntityLookupSkill FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCustomEntityLookupSkill(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
