// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> A complex object that can be used to specify alternative spellings or synonyms to the root entity name. </summary>
    public partial class CustomEntityAlias
    {
        /// <summary> Initializes a new instance of <see cref="CustomEntityAlias"/>. </summary>
        /// <param name="text"> The text of the alias. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        public CustomEntityAlias(string text)
        {
            Argument.AssertNotNull(text, nameof(text));

            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="CustomEntityAlias"/>. </summary>
        /// <param name="text"> The text of the alias. </param>
        /// <param name="caseSensitive"> Determine if the alias is case sensitive. </param>
        /// <param name="accentSensitive"> Determine if the alias is accent sensitive. </param>
        /// <param name="fuzzyEditDistance"> Determine the fuzzy edit distance of the alias. </param>
        internal CustomEntityAlias(string text, bool? caseSensitive, bool? accentSensitive, int? fuzzyEditDistance)
        {
            Text = text;
            CaseSensitive = caseSensitive;
            AccentSensitive = accentSensitive;
            FuzzyEditDistance = fuzzyEditDistance;
        }

        /// <summary> The text of the alias. </summary>
        public string Text { get; set; }
        /// <summary> Determine if the alias is case sensitive. </summary>
        public bool? CaseSensitive { get; set; }
        /// <summary> Determine if the alias is accent sensitive. </summary>
        public bool? AccentSensitive { get; set; }
        /// <summary> Determine the fuzzy edit distance of the alias. </summary>
        public int? FuzzyEditDistance { get; set; }
    }
}
