// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Determines algorithm for text extraction from PDF files in Azure blob storage. </summary>
    public readonly partial struct BlobIndexerPdfTextRotationAlgorithm : IEquatable<BlobIndexerPdfTextRotationAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobIndexerPdfTextRotationAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobIndexerPdfTextRotationAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string DetectAnglesValue = "detectAngles";

        /// <summary> Leverages normal text extraction.  This is the default. </summary>
        public static BlobIndexerPdfTextRotationAlgorithm None { get; } = new BlobIndexerPdfTextRotationAlgorithm(NoneValue);
        /// <summary> May produce better and more readable text extraction from PDF files that have rotated text within them.  Note that there may be a small performance speed impact when this parameter is used.  This parameter only applies to PDF files, and only to PDFs with embedded text.  If the rotated text appears within an embedded image in the PDF, this parameter does not apply. </summary>
        public static BlobIndexerPdfTextRotationAlgorithm DetectAngles { get; } = new BlobIndexerPdfTextRotationAlgorithm(DetectAnglesValue);
        /// <summary> Determines if two <see cref="BlobIndexerPdfTextRotationAlgorithm"/> values are the same. </summary>
        public static bool operator ==(BlobIndexerPdfTextRotationAlgorithm left, BlobIndexerPdfTextRotationAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobIndexerPdfTextRotationAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(BlobIndexerPdfTextRotationAlgorithm left, BlobIndexerPdfTextRotationAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobIndexerPdfTextRotationAlgorithm"/>. </summary>
        public static implicit operator BlobIndexerPdfTextRotationAlgorithm(string value) => new BlobIndexerPdfTextRotationAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobIndexerPdfTextRotationAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobIndexerPdfTextRotationAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
