// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Determines how to process embedded images and image files in Azure blob storage.  Setting the "imageAction" configuration to any value other than "none" requires that a skillset also be attached to that indexer. </summary>
    public readonly partial struct BlobIndexerImageAction : IEquatable<BlobIndexerImageAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobIndexerImageAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobIndexerImageAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string GenerateNormalizedImagesValue = "generateNormalizedImages";
        private const string GenerateNormalizedImagePerPageValue = "generateNormalizedImagePerPage";

        /// <summary> Ignores embedded images or image files in the data set.  This is the default. </summary>
        public static BlobIndexerImageAction None { get; } = new BlobIndexerImageAction(NoneValue);
        /// <summary> Extracts text from images (for example, the word "STOP" from a traffic stop sign), and embeds it into the content field.  This action requires that "dataToExtract" is set to "contentAndMetadata".  A normalized image refers to additional processing resulting in uniform image output, sized and rotated to promote consistent rendering when you include images in visual search results. This information is generated for each image when you use this option. </summary>
        public static BlobIndexerImageAction GenerateNormalizedImages { get; } = new BlobIndexerImageAction(GenerateNormalizedImagesValue);
        /// <summary> Extracts text from images (for example, the word "STOP" from a traffic stop sign), and embeds it into the content field, but treats PDF files differently in that each page will be rendered as an image and normalized accordingly, instead of extracting embedded images.  Non-PDF file types will be treated the same as if "generateNormalizedImages" was set. </summary>
        public static BlobIndexerImageAction GenerateNormalizedImagePerPage { get; } = new BlobIndexerImageAction(GenerateNormalizedImagePerPageValue);
        /// <summary> Determines if two <see cref="BlobIndexerImageAction"/> values are the same. </summary>
        public static bool operator ==(BlobIndexerImageAction left, BlobIndexerImageAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobIndexerImageAction"/> values are not the same. </summary>
        public static bool operator !=(BlobIndexerImageAction left, BlobIndexerImageAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobIndexerImageAction"/>. </summary>
        public static implicit operator BlobIndexerImageAction(string value) => new BlobIndexerImageAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobIndexerImageAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobIndexerImageAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
