// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the data to extract from Azure blob storage and tells the indexer which data to extract from image content when "imageAction" is set to a value other than "none".  This applies to embedded image content in a .PDF or other application, or image files such as .jpg and .png, in Azure blobs. </summary>
    public readonly partial struct BlobIndexerDataToExtract : IEquatable<BlobIndexerDataToExtract>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobIndexerDataToExtract"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobIndexerDataToExtract(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageMetadataValue = "storageMetadata";
        private const string AllMetadataValue = "allMetadata";
        private const string ContentAndMetadataValue = "contentAndMetadata";

        /// <summary> Indexes just the standard blob properties and user-specified metadata. </summary>
        public static BlobIndexerDataToExtract StorageMetadata { get; } = new BlobIndexerDataToExtract(StorageMetadataValue);
        /// <summary> Extracts metadata provided by the Azure blob storage subsystem and the content-type specific metadata (for example, metadata unique to just .png files are indexed). </summary>
        public static BlobIndexerDataToExtract AllMetadata { get; } = new BlobIndexerDataToExtract(AllMetadataValue);
        /// <summary> Extracts all metadata and textual content from each blob. </summary>
        public static BlobIndexerDataToExtract ContentAndMetadata { get; } = new BlobIndexerDataToExtract(ContentAndMetadataValue);
        /// <summary> Determines if two <see cref="BlobIndexerDataToExtract"/> values are the same. </summary>
        public static bool operator ==(BlobIndexerDataToExtract left, BlobIndexerDataToExtract right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobIndexerDataToExtract"/> values are not the same. </summary>
        public static bool operator !=(BlobIndexerDataToExtract left, BlobIndexerDataToExtract right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobIndexerDataToExtract"/>. </summary>
        public static implicit operator BlobIndexerDataToExtract(string value) => new BlobIndexerDataToExtract(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobIndexerDataToExtract other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobIndexerDataToExtract other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
