// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the Azure OpenAI resource used to vectorize a query string. </summary>
    public partial class AzureOpenAIVectorizer : VectorSearchVectorizer
    {
        /// <summary> Initializes a new instance of <see cref="AzureOpenAIVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vectorizerName"/> is null. </exception>
        public AzureOpenAIVectorizer(string vectorizerName) : base(vectorizerName)
        {
            Argument.AssertNotNull(vectorizerName, nameof(vectorizerName));

            Kind = VectorSearchVectorizerKind.AzureOpenAI;
        }

        /// <summary> Initializes a new instance of <see cref="AzureOpenAIVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <param name="kind"> The name of the kind of vectorization method being configured for use with vector search. </param>
        /// <param name="parameters"> Contains the parameters specific to Azure OpenAI embedding vectorization. </param>
        internal AzureOpenAIVectorizer(string vectorizerName, VectorSearchVectorizerKind kind, AzureOpenAIVectorizerParameters parameters) : base(vectorizerName, kind)
        {
            Parameters = parameters;
            Kind = kind;
        }

        /// <summary> Contains the parameters specific to Azure OpenAI embedding vectorization. </summary>
        public AzureOpenAIVectorizerParameters Parameters { get; set; }
    }
}
