// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The AzureOpenAITokenizerParameters. </summary>
    public partial class AzureOpenAITokenizerParameters
    {
        /// <summary> Initializes a new instance of <see cref="AzureOpenAITokenizerParameters"/>. </summary>
        public AzureOpenAITokenizerParameters()
        {
            AllowedSpecialTokens = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureOpenAITokenizerParameters"/>. </summary>
        /// <param name="encoderModelName"> Only applies if the unit is set to azureOpenAITokens. Options include 'R50k_base', 'P50k_base', 'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'. </param>
        /// <param name="allowedSpecialTokens"> (Optional) Only applies if the unit is set to azureOpenAITokens. This parameter defines a collection of special tokens that are permitted within the tokenization process. </param>
        internal AzureOpenAITokenizerParameters(SplitSkillEncoderModelName? encoderModelName, IList<string> allowedSpecialTokens)
        {
            EncoderModelName = encoderModelName;
            AllowedSpecialTokens = allowedSpecialTokens;
        }

        /// <summary> Only applies if the unit is set to azureOpenAITokens. Options include 'R50k_base', 'P50k_base', 'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'. </summary>
        public SplitSkillEncoderModelName? EncoderModelName { get; set; }
        /// <summary> (Optional) Only applies if the unit is set to azureOpenAITokens. This parameter defines a collection of special tokens that are permitted within the tokenization process. </summary>
        public IList<string> AllowedSpecialTokens { get; }
    }
}
