// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class AzureOpenAITokenizerParameters : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(EncoderModelName))
            {
                if (EncoderModelName != null)
                {
                    writer.WritePropertyName("encoderModelName"u8);
                    writer.WriteStringValue(EncoderModelName.Value.ToString());
                }
                else
                {
                    writer.WriteNull("encoderModelName");
                }
            }
            if (Optional.IsCollectionDefined(AllowedSpecialTokens))
            {
                writer.WritePropertyName("allowedSpecialTokens"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedSpecialTokens)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        internal static AzureOpenAITokenizerParameters DeserializeAzureOpenAITokenizerParameters(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SplitSkillEncoderModelName? encoderModelName = default;
            IList<string> allowedSpecialTokens = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("encoderModelName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        encoderModelName = null;
                        continue;
                    }
                    encoderModelName = new SplitSkillEncoderModelName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("allowedSpecialTokens"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allowedSpecialTokens = array;
                    continue;
                }
            }
            return new AzureOpenAITokenizerParameters(encoderModelName, allowedSpecialTokens ?? new ChangeTrackingList<string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AzureOpenAITokenizerParameters FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAzureOpenAITokenizerParameters(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
