// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the properties for connecting to an AML vectorizer. </summary>
    public partial class AzureMachineLearningParameters
    {
        /// <summary> Initializes a new instance of <see cref="AzureMachineLearningParameters"/>. </summary>
        /// <param name="scoringUri"> (Required for no authentication or key authentication) The scoring URI of the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed. </param>
        public AzureMachineLearningParameters(Uri scoringUri)
        {
            ScoringUri = scoringUri;
        }

        /// <summary> Initializes a new instance of <see cref="AzureMachineLearningParameters"/>. </summary>
        /// <param name="scoringUri"> (Required for no authentication or key authentication) The scoring URI of the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed. </param>
        /// <param name="authenticationKey"> (Required for key authentication) The key for the AML service. </param>
        /// <param name="resourceId"> (Required for token authentication). The Azure Resource Manager resource ID of the AML service. It should be in the format subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}. </param>
        /// <param name="timeout"> (Optional) When specified, indicates the timeout for the http client making the API call. </param>
        /// <param name="region"> (Optional for token authentication). The region the AML service is deployed in. </param>
        /// <param name="modelName"> The name of the embedding model from the Azure AI Studio Catalog that is deployed at the provided endpoint. </param>
        internal AzureMachineLearningParameters(Uri scoringUri, string authenticationKey, string resourceId, TimeSpan? timeout, string region, AIStudioModelCatalogName? modelName)
        {
            ScoringUri = scoringUri;
            AuthenticationKey = authenticationKey;
            ResourceId = resourceId;
            Timeout = timeout;
            Region = region;
            ModelName = modelName;
        }

        /// <summary> (Required for no authentication or key authentication) The scoring URI of the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed. </summary>
        public Uri ScoringUri { get; set; }
        /// <summary> (Required for key authentication) The key for the AML service. </summary>
        public string AuthenticationKey { get; set; }
        /// <summary> (Required for token authentication). The Azure Resource Manager resource ID of the AML service. It should be in the format subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}. </summary>
        public string ResourceId { get; set; }
        /// <summary> (Optional) When specified, indicates the timeout for the http client making the API call. </summary>
        public TimeSpan? Timeout { get; set; }
        /// <summary> (Optional for token authentication). The region the AML service is deployed in. </summary>
        public string Region { get; set; }
        /// <summary> The name of the embedding model from the Azure AI Studio Catalog that is deployed at the provided endpoint. </summary>
        public AIStudioModelCatalogName? ModelName { get; set; }
    }
}
