// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class AutocompleteResults
    {
        internal static AutocompleteResults DeserializeAutocompleteResults(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? searchCoverage = default;
            IReadOnlyList<AutocompleteItem> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@search.coverage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    searchCoverage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    List<AutocompleteItem> array = new List<AutocompleteItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AutocompleteItem.DeserializeAutocompleteItem(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new AutocompleteResults(searchCoverage, value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AutocompleteResults FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAutocompleteResults(document.RootElement);
        }
    }
}
