// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class AutocompleteItem
    {
        internal static AutocompleteItem DeserializeAutocompleteItem(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string text = default;
            string queryPlusText = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("text"u8))
                {
                    text = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queryPlusText"u8))
                {
                    queryPlusText = property.Value.GetString();
                    continue;
                }
            }
            return new AutocompleteItem(text, queryPlusText);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AutocompleteItem FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAutocompleteItem(document.RootElement);
        }
    }
}
