// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class AnalyzedTokenInfo
    {
        internal static AnalyzedTokenInfo DeserializeAnalyzedTokenInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string token = default;
            int startOffset = default;
            int endOffset = default;
            int position = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("token"u8))
                {
                    token = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startOffset"u8))
                {
                    startOffset = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("endOffset"u8))
                {
                    endOffset = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("position"u8))
                {
                    position = property.Value.GetInt32();
                    continue;
                }
            }
            return new AnalyzedTokenInfo(token, startOffset, endOffset, position);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnalyzedTokenInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnalyzedTokenInfo(document.RootElement);
        }
    }
}
