// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Search.Documents.Indexes.Models
{
    internal partial class AnalyzeResult
    {
        internal static AnalyzeResult DeserializeAnalyzeResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<AnalyzedTokenInfo> tokens = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tokens"u8))
                {
                    List<AnalyzedTokenInfo> array = new List<AnalyzedTokenInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AnalyzedTokenInfo.DeserializeAnalyzedTokenInfo(item));
                    }
                    tokens = array;
                    continue;
                }
            }
            return new AnalyzeResult(tokens);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnalyzeResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnalyzeResult(document.RootElement);
        }
    }
}
