// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The name of the embedding model from the Azure AI Studio Catalog that will be called. </summary>
    public readonly partial struct AIStudioModelCatalogName : IEquatable<AIStudioModelCatalogName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AIStudioModelCatalogName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AIStudioModelCatalogName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OpenAIClipImageTextEmbeddingsVitBasePatch32Value = "OpenAI-CLIP-Image-Text-Embeddings-vit-base-patch32";
        private const string OpenAIClipImageTextEmbeddingsViTLargePatch14336Value = "OpenAI-CLIP-Image-Text-Embeddings-ViT-Large-Patch14-336";
        private const string FacebookDinoV2ImageEmbeddingsViTBaseValue = "Facebook-DinoV2-Image-Embeddings-ViT-Base";
        private const string FacebookDinoV2ImageEmbeddingsViTGiantValue = "Facebook-DinoV2-Image-Embeddings-ViT-Giant";
        private const string CohereEmbedV3EnglishValue = "Cohere-embed-v3-english";
        private const string CohereEmbedV3MultilingualValue = "Cohere-embed-v3-multilingual";

        /// <summary> OpenAI-CLIP-Image-Text-Embeddings-vit-base-patch32. </summary>
        public static AIStudioModelCatalogName OpenAIClipImageTextEmbeddingsVitBasePatch32 { get; } = new AIStudioModelCatalogName(OpenAIClipImageTextEmbeddingsVitBasePatch32Value);
        /// <summary> OpenAI-CLIP-Image-Text-Embeddings-ViT-Large-Patch14-336. </summary>
        public static AIStudioModelCatalogName OpenAIClipImageTextEmbeddingsViTLargePatch14336 { get; } = new AIStudioModelCatalogName(OpenAIClipImageTextEmbeddingsViTLargePatch14336Value);
        /// <summary> Facebook-DinoV2-Image-Embeddings-ViT-Base. </summary>
        public static AIStudioModelCatalogName FacebookDinoV2ImageEmbeddingsViTBase { get; } = new AIStudioModelCatalogName(FacebookDinoV2ImageEmbeddingsViTBaseValue);
        /// <summary> Facebook-DinoV2-Image-Embeddings-ViT-Giant. </summary>
        public static AIStudioModelCatalogName FacebookDinoV2ImageEmbeddingsViTGiant { get; } = new AIStudioModelCatalogName(FacebookDinoV2ImageEmbeddingsViTGiantValue);
        /// <summary> Cohere-embed-v3-english. </summary>
        public static AIStudioModelCatalogName CohereEmbedV3English { get; } = new AIStudioModelCatalogName(CohereEmbedV3EnglishValue);
        /// <summary> Cohere-embed-v3-multilingual. </summary>
        public static AIStudioModelCatalogName CohereEmbedV3Multilingual { get; } = new AIStudioModelCatalogName(CohereEmbedV3MultilingualValue);
        /// <summary> Determines if two <see cref="AIStudioModelCatalogName"/> values are the same. </summary>
        public static bool operator ==(AIStudioModelCatalogName left, AIStudioModelCatalogName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AIStudioModelCatalogName"/> values are not the same. </summary>
        public static bool operator !=(AIStudioModelCatalogName left, AIStudioModelCatalogName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AIStudioModelCatalogName"/>. </summary>
        public static implicit operator AIStudioModelCatalogName(string value) => new AIStudioModelCatalogName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AIStudioModelCatalogName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AIStudioModelCatalogName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
