// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the AI Services Vision parameters for vectorizing a query image or text. </summary>
    public partial class AIServicesVisionVectorizer : VectorSearchVectorizer
    {
        /// <summary> Initializes a new instance of <see cref="AIServicesVisionVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vectorizerName"/> is null. </exception>
        public AIServicesVisionVectorizer(string vectorizerName) : base(vectorizerName)
        {
            Argument.AssertNotNull(vectorizerName, nameof(vectorizerName));

            Kind = VectorSearchVectorizerKind.AIServicesVision;
        }

        /// <summary> Initializes a new instance of <see cref="AIServicesVisionVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <param name="kind"> The name of the kind of vectorization method being configured for use with vector search. </param>
        /// <param name="aiServicesVisionParameters"> Contains the parameters specific to AI Services Vision embedding vectorization. </param>
        internal AIServicesVisionVectorizer(string vectorizerName, VectorSearchVectorizerKind kind, AIServicesVisionParameters aiServicesVisionParameters) : base(vectorizerName, kind)
        {
            AIServicesVisionParameters = aiServicesVisionParameters;
            Kind = kind;
        }

        /// <summary> Contains the parameters specific to AI Services Vision embedding vectorization. </summary>
        public AIServicesVisionParameters AIServicesVisionParameters { get; set; }
    }
}
