// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies the AI Services Vision parameters for vectorizing a query image or text. </summary>
    public partial class AIServicesVisionParameters
    {
        /// <summary> Initializes a new instance of <see cref="AIServicesVisionParameters"/>. </summary>
        /// <param name="modelVersion"> The version of the model to use when calling the AI Services Vision service. It will default to the latest available when not specified. </param>
        /// <param name="resourceUri"> The resource URI of the AI Services resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceUri"/> is null. </exception>
        public AIServicesVisionParameters(string modelVersion, Uri resourceUri)
        {
            Argument.AssertNotNull(resourceUri, nameof(resourceUri));

            ModelVersion = modelVersion;
            ResourceUri = resourceUri;
        }

        /// <summary> Initializes a new instance of <see cref="AIServicesVisionParameters"/>. </summary>
        /// <param name="modelVersion"> The version of the model to use when calling the AI Services Vision service. It will default to the latest available when not specified. </param>
        /// <param name="resourceUri"> The resource URI of the AI Services resource. </param>
        /// <param name="apiKey"> API key of the designated AI Services resource. </param>
        /// <param name="authIdentity">
        /// The user-assigned managed identity used for outbound connections. If an authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to the index, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
        /// Please note <see cref="SearchIndexerDataIdentity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SearchIndexerDataNoneIdentity"/> and <see cref="SearchIndexerDataUserAssignedIdentity"/>.
        /// </param>
        internal AIServicesVisionParameters(string modelVersion, Uri resourceUri, string apiKey, SearchIndexerDataIdentity authIdentity)
        {
            ModelVersion = modelVersion;
            ResourceUri = resourceUri;
            ApiKey = apiKey;
            AuthIdentity = authIdentity;
        }

        /// <summary> The version of the model to use when calling the AI Services Vision service. It will default to the latest available when not specified. </summary>
        public string ModelVersion { get; set; }
        /// <summary> The resource URI of the AI Services resource. </summary>
        public Uri ResourceUri { get; set; }
        /// <summary> API key of the designated AI Services resource. </summary>
        public string ApiKey { get; set; }
        /// <summary>
        /// The user-assigned managed identity used for outbound connections. If an authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to the index, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
        /// Please note <see cref="SearchIndexerDataIdentity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SearchIndexerDataNoneIdentity"/> and <see cref="SearchIndexerDataUserAssignedIdentity"/>.
        /// </summary>
        public SearchIndexerDataIdentity AuthIdentity { get; set; }
    }
}
