// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Search.Models;

namespace Azure.ResourceManager.Search
{
    /// <summary>
    /// A class representing the NetworkSecurityPerimeterConfiguration data model.
    /// Network security perimeter configuration for a server.
    /// </summary>
    public partial class NetworkSecurityPerimeterConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationData"/>. </summary>
        public NetworkSecurityPerimeterConfigurationData()
        {
            ProvisioningIssues = new ChangeTrackingList<NspProvisioningIssue>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"></param>
        /// <param name="networkSecurityPerimeter"> The perimeter for a network security perimeter configuration. </param>
        /// <param name="resourceAssociation"> The resource association for the network security perimeter. </param>
        /// <param name="profile"> The profile for a network security perimeter configuration. </param>
        /// <param name="provisioningIssues"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeterConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string provisioningState, NspConfigPerimeter networkSecurityPerimeter, NspConfigAssociation resourceAssociation, NspConfigProfile profile, IList<NspProvisioningIssue> provisioningIssues, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            NetworkSecurityPerimeter = networkSecurityPerimeter;
            ResourceAssociation = resourceAssociation;
            Profile = profile;
            ProvisioningIssues = provisioningIssues;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> The perimeter for a network security perimeter configuration. </summary>
        [WirePath("properties.networkSecurityPerimeter")]
        public NspConfigPerimeter NetworkSecurityPerimeter { get; set; }
        /// <summary> The resource association for the network security perimeter. </summary>
        [WirePath("properties.resourceAssociation")]
        public NspConfigAssociation ResourceAssociation { get; set; }
        /// <summary> The profile for a network security perimeter configuration. </summary>
        [WirePath("properties.profile")]
        public NspConfigProfile Profile { get; set; }
        /// <summary> Gets the provisioning issues. </summary>
        [WirePath("properties.provisioningIssues")]
        public IList<NspProvisioningIssue> ProvisioningIssues { get; }
    }
}
