// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchServiceStatusExtensions
    {
        public static string ToSerialString(this SearchServiceStatus value) => value switch
        {
            SearchServiceStatus.Running => "running",
            SearchServiceStatus.Provisioning => "provisioning",
            SearchServiceStatus.Deleting => "deleting",
            SearchServiceStatus.Degraded => "degraded",
            SearchServiceStatus.Disabled => "disabled",
            SearchServiceStatus.Error => "error",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceStatus value.")
        };

        public static SearchServiceStatus ToSearchServiceStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "running")) return SearchServiceStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "provisioning")) return SearchServiceStatus.Provisioning;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "deleting")) return SearchServiceStatus.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "degraded")) return SearchServiceStatus.Degraded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "disabled")) return SearchServiceStatus.Disabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "error")) return SearchServiceStatus.Error;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceStatus value.");
        }
    }
}
