// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> The provisioning state of the shared private link resource. Valid values are Updating, Deleting, Failed, Succeeded or Incomplete. </summary>
    public readonly partial struct SearchServiceSharedPrivateLinkResourceProvisioningState : IEquatable<SearchServiceSharedPrivateLinkResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SearchServiceSharedPrivateLinkResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SearchServiceSharedPrivateLinkResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string IncompleteValue = "Incomplete";

        /// <summary> The shared private link resource is in the process of being created along with other resources for it to be fully functional. </summary>
        public static SearchServiceSharedPrivateLinkResourceProvisioningState Updating { get; } = new SearchServiceSharedPrivateLinkResourceProvisioningState(UpdatingValue);
        /// <summary> The shared private link resource is in the process of being deleted. </summary>
        public static SearchServiceSharedPrivateLinkResourceProvisioningState Deleting { get; } = new SearchServiceSharedPrivateLinkResourceProvisioningState(DeletingValue);
        /// <summary> The shared private link resource has failed to be provisioned or deleted. </summary>
        public static SearchServiceSharedPrivateLinkResourceProvisioningState Failed { get; } = new SearchServiceSharedPrivateLinkResourceProvisioningState(FailedValue);
        /// <summary> The shared private link resource has finished provisioning and is ready for approval. </summary>
        public static SearchServiceSharedPrivateLinkResourceProvisioningState Succeeded { get; } = new SearchServiceSharedPrivateLinkResourceProvisioningState(SucceededValue);
        /// <summary> Provisioning request for the shared private link resource has been accepted but the process of creation has not commenced yet. </summary>
        public static SearchServiceSharedPrivateLinkResourceProvisioningState Incomplete { get; } = new SearchServiceSharedPrivateLinkResourceProvisioningState(IncompleteValue);
        /// <summary> Determines if two <see cref="SearchServiceSharedPrivateLinkResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SearchServiceSharedPrivateLinkResourceProvisioningState left, SearchServiceSharedPrivateLinkResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SearchServiceSharedPrivateLinkResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SearchServiceSharedPrivateLinkResourceProvisioningState left, SearchServiceSharedPrivateLinkResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SearchServiceSharedPrivateLinkResourceProvisioningState"/>. </summary>
        public static implicit operator SearchServiceSharedPrivateLinkResourceProvisioningState(string value) => new SearchServiceSharedPrivateLinkResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SearchServiceSharedPrivateLinkResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SearchServiceSharedPrivateLinkResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
