// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> The type of the resource whose name is to be validated. This value must always be 'searchServices'. </summary>
    public readonly partial struct SearchServiceResourceType : IEquatable<SearchServiceResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SearchServiceResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SearchServiceResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SearchServicesValue = "searchServices";

        /// <summary> searchServices. </summary>
        public static SearchServiceResourceType SearchServices { get; } = new SearchServiceResourceType(SearchServicesValue);
        /// <summary> Determines if two <see cref="SearchServiceResourceType"/> values are the same. </summary>
        public static bool operator ==(SearchServiceResourceType left, SearchServiceResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SearchServiceResourceType"/> values are not the same. </summary>
        public static bool operator !=(SearchServiceResourceType left, SearchServiceResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SearchServiceResourceType"/>. </summary>
        public static implicit operator SearchServiceResourceType(string value) => new SearchServiceResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SearchServiceResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SearchServiceResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
