// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> Describes an API key for a given Azure AI Search service that conveys read-only permissions on the docs collection of an index. </summary>
    public partial class SearchServiceQueryKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchServiceQueryKey"/>. </summary>
        internal SearchServiceQueryKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SearchServiceQueryKey"/>. </summary>
        /// <param name="name"> The name of the query API key. Query names are optional, but assigning a name can help you remember how it's used. </param>
        /// <param name="key"> The value of the query API key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchServiceQueryKey(string name, string key, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Key = key;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the query API key. Query names are optional, but assigning a name can help you remember how it's used. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The value of the query API key. </summary>
        [WirePath("key")]
        public string Key { get; }
    }
}
