// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchServiceProvisioningStateExtensions
    {
        public static string ToSerialString(this SearchServiceProvisioningState value) => value switch
        {
            SearchServiceProvisioningState.Succeeded => "Succeeded",
            SearchServiceProvisioningState.Provisioning => "Provisioning",
            SearchServiceProvisioningState.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceProvisioningState value.")
        };

        public static SearchServiceProvisioningState ToSearchServiceProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return SearchServiceProvisioningState.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Provisioning")) return SearchServiceProvisioningState.Provisioning;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return SearchServiceProvisioningState.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceProvisioningState value.");
        }
    }
}
