// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchServicePrivateLinkServiceConnectionStatusExtensions
    {
        public static string ToSerialString(this SearchServicePrivateLinkServiceConnectionStatus value) => value switch
        {
            SearchServicePrivateLinkServiceConnectionStatus.Pending => "Pending",
            SearchServicePrivateLinkServiceConnectionStatus.Approved => "Approved",
            SearchServicePrivateLinkServiceConnectionStatus.Rejected => "Rejected",
            SearchServicePrivateLinkServiceConnectionStatus.Disconnected => "Disconnected",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServicePrivateLinkServiceConnectionStatus value.")
        };

        public static SearchServicePrivateLinkServiceConnectionStatus ToSearchServicePrivateLinkServiceConnectionStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pending")) return SearchServicePrivateLinkServiceConnectionStatus.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Approved")) return SearchServicePrivateLinkServiceConnectionStatus.Approved;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Rejected")) return SearchServicePrivateLinkServiceConnectionStatus.Rejected;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disconnected")) return SearchServicePrivateLinkServiceConnectionStatus.Disconnected;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServicePrivateLinkServiceConnectionStatus value.");
        }
    }
}
