// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> Describes the current state of an existing Azure Private Link service connection to the private endpoint. </summary>
    public partial class SearchServicePrivateLinkServiceConnectionState
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchServicePrivateLinkServiceConnectionState"/>. </summary>
        public SearchServicePrivateLinkServiceConnectionState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SearchServicePrivateLinkServiceConnectionState"/>. </summary>
        /// <param name="status"> Status of the the private link service connection. Valid values are Pending, Approved, Rejected, or Disconnected. </param>
        /// <param name="description"> The description for the private link service connection state. </param>
        /// <param name="actionsRequired"> A description of any extra actions that may be required. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchServicePrivateLinkServiceConnectionState(SearchServicePrivateLinkServiceConnectionStatus? status, string description, string actionsRequired, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Description = description;
            ActionsRequired = actionsRequired;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Status of the the private link service connection. Valid values are Pending, Approved, Rejected, or Disconnected. </summary>
        [WirePath("status")]
        public SearchServicePrivateLinkServiceConnectionStatus? Status { get; set; }
        /// <summary> The description for the private link service connection state. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> A description of any extra actions that may be required. </summary>
        [WirePath("actionsRequired")]
        public string ActionsRequired { get; set; }
    }
}
