// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchServiceHostingModeExtensions
    {
        public static string ToSerialString(this SearchServiceHostingMode value) => value switch
        {
            SearchServiceHostingMode.Default => "default",
            SearchServiceHostingMode.HighDensity => "highDensity",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceHostingMode value.")
        };

        public static SearchServiceHostingMode ToSearchServiceHostingMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "default")) return SearchServiceHostingMode.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "highDensity")) return SearchServiceHostingMode.HighDensity;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceHostingMode value.");
        }
    }
}
