// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchServiceAdminKeyKindExtensions
    {
        public static string ToSerialString(this SearchServiceAdminKeyKind value) => value switch
        {
            SearchServiceAdminKeyKind.Primary => "primary",
            SearchServiceAdminKeyKind.Secondary => "secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceAdminKeyKind value.")
        };

        public static SearchServiceAdminKeyKind ToSearchServiceAdminKeyKind(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "primary")) return SearchServiceAdminKeyKind.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "secondary")) return SearchServiceAdminKeyKind.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchServiceAdminKeyKind value.");
        }
    }
}
