// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> Sets options that control the availability of semantic search. This configuration is only possible for certain Azure AI Search SKUs in certain locations. </summary>
    public readonly partial struct SearchSemanticSearch : IEquatable<SearchSemanticSearch>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SearchSemanticSearch"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SearchSemanticSearch(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "disabled";
        private const string FreeValue = "free";
        private const string StandardValue = "standard";

        /// <summary> Indicates that semantic reranker is disabled for the search service. This is the default. </summary>
        public static SearchSemanticSearch Disabled { get; } = new SearchSemanticSearch(DisabledValue);
        /// <summary> Enables semantic reranker on a search service and indicates that it is to be used within the limits of the free plan. The free plan would cap the volume of semantic ranking requests and is offered at no extra charge. This is the default for newly provisioned search services. </summary>
        public static SearchSemanticSearch Free { get; } = new SearchSemanticSearch(FreeValue);
        /// <summary> Enables semantic reranker on a search service as a billable feature, with higher throughput and volume of semantically reranked queries. </summary>
        public static SearchSemanticSearch Standard { get; } = new SearchSemanticSearch(StandardValue);
        /// <summary> Determines if two <see cref="SearchSemanticSearch"/> values are the same. </summary>
        public static bool operator ==(SearchSemanticSearch left, SearchSemanticSearch right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SearchSemanticSearch"/> values are not the same. </summary>
        public static bool operator !=(SearchSemanticSearch left, SearchSemanticSearch right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SearchSemanticSearch"/>. </summary>
        public static implicit operator SearchSemanticSearch(string value) => new SearchSemanticSearch(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SearchSemanticSearch other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SearchSemanticSearch other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
