// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Search.Models
{
    public partial class SearchEncryptionWithCmk : IUtf8JsonSerializable, IJsonModel<SearchEncryptionWithCmk>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SearchEncryptionWithCmk>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SearchEncryptionWithCmk>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchEncryptionWithCmk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SearchEncryptionWithCmk)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Enforcement))
            {
                writer.WritePropertyName("enforcement"u8);
                writer.WriteStringValue(Enforcement.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(EncryptionComplianceStatus))
            {
                writer.WritePropertyName("encryptionComplianceStatus"u8);
                writer.WriteStringValue(EncryptionComplianceStatus.Value.ToSerialString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SearchEncryptionWithCmk IJsonModel<SearchEncryptionWithCmk>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchEncryptionWithCmk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SearchEncryptionWithCmk)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSearchEncryptionWithCmk(document.RootElement, options);
        }

        internal static SearchEncryptionWithCmk DeserializeSearchEncryptionWithCmk(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SearchEncryptionWithCmkEnforcement? enforcement = default;
            SearchEncryptionComplianceStatus? encryptionComplianceStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enforcement"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enforcement = property.Value.GetString().ToSearchEncryptionWithCmkEnforcement();
                    continue;
                }
                if (property.NameEquals("encryptionComplianceStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encryptionComplianceStatus = property.Value.GetString().ToSearchEncryptionComplianceStatus();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SearchEncryptionWithCmk(enforcement, encryptionComplianceStatus, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Enforcement), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enforcement: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Enforcement))
                {
                    builder.Append("  enforcement: ");
                    builder.AppendLine($"'{Enforcement.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EncryptionComplianceStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  encryptionComplianceStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EncryptionComplianceStatus))
                {
                    builder.Append("  encryptionComplianceStatus: ");
                    builder.AppendLine($"'{EncryptionComplianceStatus.Value.ToSerialString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SearchEncryptionWithCmk>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchEncryptionWithCmk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SearchEncryptionWithCmk)} does not support writing '{options.Format}' format.");
            }
        }

        SearchEncryptionWithCmk IPersistableModel<SearchEncryptionWithCmk>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchEncryptionWithCmk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSearchEncryptionWithCmk(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SearchEncryptionWithCmk)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SearchEncryptionWithCmk>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
