// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SearchEncryptionComplianceStatusExtensions
    {
        public static string ToSerialString(this SearchEncryptionComplianceStatus value) => value switch
        {
            SearchEncryptionComplianceStatus.Compliant => "Compliant",
            SearchEncryptionComplianceStatus.NonCompliant => "NonCompliant",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchEncryptionComplianceStatus value.")
        };

        public static SearchEncryptionComplianceStatus ToSearchEncryptionComplianceStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Compliant")) return SearchEncryptionComplianceStatus.Compliant;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NonCompliant")) return SearchEncryptionComplianceStatus.NonCompliant;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SearchEncryptionComplianceStatus value.");
        }
    }
}
