// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> Possible origins of inbound traffic that can bypass the rules defined in the 'ipRules' section. </summary>
    public readonly partial struct SearchBypass : IEquatable<SearchBypass>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SearchBypass"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SearchBypass(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string AzurePortalValue = "AzurePortal";
        private const string AzureServicesValue = "AzureServices";

        /// <summary> Indicates that no origin can bypass the rules defined in the 'ipRules' section. This is the default. </summary>
        public static SearchBypass None { get; } = new SearchBypass(NoneValue);
        /// <summary> Indicates that requests originating from the Azure portal can bypass the rules defined in the 'ipRules' section. </summary>
        public static SearchBypass AzurePortal { get; } = new SearchBypass(AzurePortalValue);
        /// <summary> Indicates that requests originating from Azure trusted services can bypass the rules defined in the 'ipRules' section. </summary>
        public static SearchBypass AzureServices { get; } = new SearchBypass(AzureServicesValue);
        /// <summary> Determines if two <see cref="SearchBypass"/> values are the same. </summary>
        public static bool operator ==(SearchBypass left, SearchBypass right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SearchBypass"/> values are not the same. </summary>
        public static bool operator !=(SearchBypass left, SearchBypass right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SearchBypass"/>. </summary>
        public static implicit operator SearchBypass(string value) => new SearchBypass(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SearchBypass other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SearchBypass other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
