// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> Describes the quota usage for a particular SKU. </summary>
    public partial class QuotaUsageResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QuotaUsageResult"/>. </summary>
        internal QuotaUsageResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="QuotaUsageResult"/>. </summary>
        /// <param name="id"> The resource ID of the quota usage SKU endpoint for Microsoft.Search provider. </param>
        /// <param name="unit"> The unit of measurement for the search SKU. </param>
        /// <param name="currentValue"> The currently used up value for the particular search SKU. </param>
        /// <param name="limit"> The quota limit for the particular search SKU. </param>
        /// <param name="name"> The name of the SKU supported by Azure AI Search. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QuotaUsageResult(ResourceIdentifier id, string unit, int? currentValue, int? limit, QuotaUsageResultName name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Unit = unit;
            CurrentValue = currentValue;
            Limit = limit;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource ID of the quota usage SKU endpoint for Microsoft.Search provider. </summary>
        [WirePath("id")]
        public ResourceIdentifier Id { get; }
        /// <summary> The unit of measurement for the search SKU. </summary>
        [WirePath("unit")]
        public string Unit { get; }
        /// <summary> The currently used up value for the particular search SKU. </summary>
        [WirePath("currentValue")]
        public int? CurrentValue { get; }
        /// <summary> The quota limit for the particular search SKU. </summary>
        [WirePath("limit")]
        public int? Limit { get; }
        /// <summary> The name of the SKU supported by Azure AI Search. </summary>
        [WirePath("name")]
        public QuotaUsageResultName Name { get; }
    }
}
