// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Search.Models
{
    /// <summary> The properties for the access rules in a network security perimeter configuration. </summary>
    public partial class NspConfigAccessRuleProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NspConfigAccessRuleProperties"/>. </summary>
        public NspConfigAccessRuleProperties()
        {
            AddressPrefixes = new ChangeTrackingList<string>();
            FullyQualifiedDomainNames = new ChangeTrackingList<string>();
            Subscriptions = new ChangeTrackingList<string>();
            NetworkSecurityPerimeters = new ChangeTrackingList<NspConfigNetworkSecurityPerimeterRule>();
        }

        /// <summary> Initializes a new instance of <see cref="NspConfigAccessRuleProperties"/>. </summary>
        /// <param name="direction"></param>
        /// <param name="addressPrefixes"></param>
        /// <param name="fullyQualifiedDomainNames"></param>
        /// <param name="subscriptions"></param>
        /// <param name="networkSecurityPerimeters"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NspConfigAccessRuleProperties(string direction, IList<string> addressPrefixes, IList<string> fullyQualifiedDomainNames, IList<string> subscriptions, IList<NspConfigNetworkSecurityPerimeterRule> networkSecurityPerimeters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Direction = direction;
            AddressPrefixes = addressPrefixes;
            FullyQualifiedDomainNames = fullyQualifiedDomainNames;
            Subscriptions = subscriptions;
            NetworkSecurityPerimeters = networkSecurityPerimeters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the direction. </summary>
        [WirePath("direction")]
        public string Direction { get; set; }
        /// <summary> Gets the address prefixes. </summary>
        [WirePath("addressPrefixes")]
        public IList<string> AddressPrefixes { get; }
        /// <summary> Gets the fully qualified domain names. </summary>
        [WirePath("fullyQualifiedDomainNames")]
        public IList<string> FullyQualifiedDomainNames { get; }
        /// <summary> Gets the subscriptions. </summary>
        [WirePath("subscriptions")]
        public IList<string> Subscriptions { get; }
        /// <summary> Gets the network security perimeters. </summary>
        [WirePath("networkSecurityPerimeters")]
        public IList<NspConfigNetworkSecurityPerimeterRule> NetworkSecurityPerimeters { get; }
    }
}
