// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Search
{
    internal class SharedSearchServicePrivateLinkResourceOperationSource : IOperationSource<SharedSearchServicePrivateLinkResource>
    {
        private readonly ArmClient _client;

        internal SharedSearchServicePrivateLinkResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        SharedSearchServicePrivateLinkResource IOperationSource<SharedSearchServicePrivateLinkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SharedSearchServicePrivateLinkResourceData.DeserializeSharedSearchServicePrivateLinkResourceData(document.RootElement);
            return new SharedSearchServicePrivateLinkResource(_client, data);
        }

        async ValueTask<SharedSearchServicePrivateLinkResource> IOperationSource<SharedSearchServicePrivateLinkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SharedSearchServicePrivateLinkResourceData.DeserializeSharedSearchServicePrivateLinkResourceData(document.RootElement);
            return new SharedSearchServicePrivateLinkResource(_client, data);
        }
    }
}
