// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Search.Models
{
    internal static partial class SharedSearchServicePrivateLinkResourceStatusExtensions
    {
        public static string ToSerialString(this SharedSearchServicePrivateLinkResourceStatus value) => value switch
        {
            SharedSearchServicePrivateLinkResourceStatus.Pending => "Pending",
            SharedSearchServicePrivateLinkResourceStatus.Approved => "Approved",
            SharedSearchServicePrivateLinkResourceStatus.Rejected => "Rejected",
            SharedSearchServicePrivateLinkResourceStatus.Disconnected => "Disconnected",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SharedSearchServicePrivateLinkResourceStatus value.")
        };

        public static SharedSearchServicePrivateLinkResourceStatus ToSharedSearchServicePrivateLinkResourceStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pending")) return SharedSearchServicePrivateLinkResourceStatus.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Approved")) return SharedSearchServicePrivateLinkResourceStatus.Approved;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Rejected")) return SharedSearchServicePrivateLinkResourceStatus.Rejected;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disconnected")) return SharedSearchServicePrivateLinkResourceStatus.Disconnected;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SharedSearchServicePrivateLinkResourceStatus value.");
        }
    }
}
