// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core.Extensions;

namespace Azure.Data.SchemaRegistry
{
    /// <summary> Extension methods to add <see cref="SchemaRegistryClient"/> to client builder. </summary>
    internal static partial class DataSchemaRegistryClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="SchemaRegistryClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The Schema Registry service endpoint, for example 'my-namespace.servicebus.windows.net'. </param>
        public static IAzureClientBuilder<SchemaRegistryClient, SchemaRegistryClientOptions> AddSchemaRegistryClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<SchemaRegistryClient, SchemaRegistryClientOptions>((options, cred) => new SchemaRegistryClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="SchemaRegistryClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<SchemaRegistryClient, SchemaRegistryClientOptions> AddSchemaRegistryClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<SchemaRegistryClient, SchemaRegistryClientOptions>(configuration);
        }
    }
}
