// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A Class representing a TenantDataBoundary along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="TenantDataBoundaryResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetTenantDataBoundaryResource method.
    /// Otherwise you can get one from its parent resource <see cref="TenantResource"/> using the GetTenantDataBoundary method.
    /// </summary>
    public partial class TenantDataBoundaryResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="TenantDataBoundaryResource"/> instance. </summary>
        /// <param name="name"> The name. </param>
        public static ResourceIdentifier CreateResourceIdentifier(DataBoundaryName name)
        {
            var resourceId = $"/providers/Microsoft.Resources/dataBoundaries/{name}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _tenantDataBoundaryDataBoundariesClientDiagnostics;
        private readonly DataBoundariesRestOperations _tenantDataBoundaryDataBoundariesRestClient;
        private readonly DataBoundaryData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Resources/dataBoundaries";

        /// <summary> Initializes a new instance of the <see cref="TenantDataBoundaryResource"/> class for mocking. </summary>
        protected TenantDataBoundaryResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="TenantDataBoundaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal TenantDataBoundaryResource(ArmClient client, DataBoundaryData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="TenantDataBoundaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal TenantDataBoundaryResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _tenantDataBoundaryDataBoundariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string tenantDataBoundaryDataBoundariesApiVersion);
            _tenantDataBoundaryDataBoundariesRestClient = new DataBoundariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, tenantDataBoundaryDataBoundariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DataBoundaryData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get data boundary of tenant.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<TenantDataBoundaryResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryResource.Get");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.GetTenantAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get data boundary of tenant.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<TenantDataBoundaryResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryResource.Get");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.GetTenant(Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Opt-in tenant to data boundary.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The data boundary to opt the tenant to. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<TenantDataBoundaryResource>> UpdateAsync(WaitUntil waitUntil, DataBoundaryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryResource.Update");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.PutAsync(Id.Name, data, cancellationToken).ConfigureAwait(false);
                var uri = _tenantDataBoundaryDataBoundariesRestClient.CreatePutRequestUri(Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ResourcesArmOperation<TenantDataBoundaryResource>(Response.FromValue(new TenantDataBoundaryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Opt-in tenant to data boundary.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The data boundary to opt the tenant to. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<TenantDataBoundaryResource> Update(WaitUntil waitUntil, DataBoundaryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryResource.Update");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.Put(Id.Name, data, cancellationToken);
                var uri = _tenantDataBoundaryDataBoundariesRestClient.CreatePutRequestUri(Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ResourcesArmOperation<TenantDataBoundaryResource>(Response.FromValue(new TenantDataBoundaryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
