// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing a collection of <see cref="TenantDataBoundaryResource"/> and their operations.
    /// Each <see cref="TenantDataBoundaryResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="TenantDataBoundaryCollection"/> instance call the GetTenantDataBoundaries method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class TenantDataBoundaryCollection : ArmCollection
    {
        private readonly ClientDiagnostics _tenantDataBoundaryDataBoundariesClientDiagnostics;
        private readonly DataBoundariesRestOperations _tenantDataBoundaryDataBoundariesRestClient;

        /// <summary> Initializes a new instance of the <see cref="TenantDataBoundaryCollection"/> class for mocking. </summary>
        protected TenantDataBoundaryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="TenantDataBoundaryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal TenantDataBoundaryCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _tenantDataBoundaryDataBoundariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", TenantDataBoundaryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(TenantDataBoundaryResource.ResourceType, out string tenantDataBoundaryDataBoundariesApiVersion);
            _tenantDataBoundaryDataBoundariesRestClient = new DataBoundariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, tenantDataBoundaryDataBoundariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Opt-in tenant to data boundary.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="data"> The data boundary to opt the tenant to. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<TenantDataBoundaryResource>> CreateOrUpdateAsync(WaitUntil waitUntil, DataBoundaryName name, DataBoundaryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.PutAsync(name, data, cancellationToken).ConfigureAwait(false);
                var uri = _tenantDataBoundaryDataBoundariesRestClient.CreatePutRequestUri(name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ResourcesArmOperation<TenantDataBoundaryResource>(Response.FromValue(new TenantDataBoundaryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Opt-in tenant to data boundary.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="data"> The data boundary to opt the tenant to. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<TenantDataBoundaryResource> CreateOrUpdate(WaitUntil waitUntil, DataBoundaryName name, DataBoundaryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.Put(name, data, cancellationToken);
                var uri = _tenantDataBoundaryDataBoundariesRestClient.CreatePutRequestUri(name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ResourcesArmOperation<TenantDataBoundaryResource>(Response.FromValue(new TenantDataBoundaryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get data boundary of tenant.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<TenantDataBoundaryResource>> GetAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.Get");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.GetTenantAsync(name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get data boundary of tenant.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<TenantDataBoundaryResource> Get(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.Get");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.GetTenant(name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.GetTenantAsync(name, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.Exists");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.GetTenant(name, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<TenantDataBoundaryResource>> GetIfExistsAsync(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _tenantDataBoundaryDataBoundariesRestClient.GetTenantAsync(name, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<TenantDataBoundaryResource>(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Resources/dataBoundaries/{default}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataBoundaries_GetTenant</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TenantDataBoundaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Default string modeled as parameter for auto generation to work correctly. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<TenantDataBoundaryResource> GetIfExists(DataBoundaryName name, CancellationToken cancellationToken = default)
        {
            using var scope = _tenantDataBoundaryDataBoundariesClientDiagnostics.CreateScope("TenantDataBoundaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _tenantDataBoundaryDataBoundariesRestClient.GetTenant(name, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<TenantDataBoundaryResource>(response.GetRawResponse());
                return Response.FromValue(new TenantDataBoundaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
