// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    internal partial class DeploymentStacksRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of DeploymentStacksRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public DeploymentStacksRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-03-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateExportTemplateAtScopeRequestUri(string scope, string deploymentStackName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendPath("/exportTemplate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateExportTemplateAtScopeRequest(string scope, string deploymentStackName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendPath("/exportTemplate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Exports the template used to create the Deployment stack. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DeploymentStackTemplateDefinition>> ExportTemplateAtScopeAsync(string scope, string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateExportTemplateAtScopeRequest(scope, deploymentStackName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackTemplateDefinition value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeploymentStackTemplateDefinition.DeserializeDeploymentStackTemplateDefinition(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Exports the template used to create the Deployment stack. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DeploymentStackTemplateDefinition> ExportTemplateAtScope(string scope, string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateExportTemplateAtScopeRequest(scope, deploymentStackName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackTemplateDefinition value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeploymentStackTemplateDefinition.DeserializeDeploymentStackTemplateDefinition(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateValidateStackAtScopeRequestUri(string scope, string deploymentStackName, DeploymentStackData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendPath("/validate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateValidateStackAtScopeRequest(string scope, string deploymentStackName, DeploymentStackData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendPath("/validate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Runs preflight validation on the specific scoped Deployment stack template to verify its acceptance to Azure Resource Manager. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack to validate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/>, <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> ValidateStackAtScopeAsync(string scope, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateValidateStackAtScopeRequest(scope, deploymentStackName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 400:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Runs preflight validation on the specific scoped Deployment stack template to verify its acceptance to Azure Resource Manager. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack to validate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/>, <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response ValidateStackAtScope(string scope, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateValidateStackAtScopeRequest(scope, deploymentStackName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 400:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListAtScopeRequestUri(string scope)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateListAtScopeRequest(string scope)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists all the Deployment stacks within the specified scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> is null. </exception>
        public async Task<Response<DeploymentStackListResult>> ListAtScopeAsync(string scope, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));

            using var message = CreateListAtScopeRequest(scope);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeploymentStackListResult.DeserializeDeploymentStackListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all the Deployment stacks within the specified scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> is null. </exception>
        public Response<DeploymentStackListResult> ListAtScope(string scope, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));

            using var message = CreateListAtScopeRequest(scope);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeploymentStackListResult.DeserializeDeploymentStackListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateAtScopeRequestUri(string scope, string deploymentStackName, DeploymentStackData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateCreateOrUpdateAtScopeRequest(string scope, string deploymentStackName, DeploymentStackData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates or updates a Deployment stack at specific scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack supplied to the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/>, <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> CreateOrUpdateAtScopeAsync(string scope, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateAtScopeRequest(scope, deploymentStackName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a Deployment stack at specific scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="data"> Deployment stack supplied to the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/>, <paramref name="deploymentStackName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response CreateOrUpdateAtScope(string scope, string deploymentStackName, DeploymentStackData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateAtScopeRequest(scope, deploymentStackName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetAtScopeRequestUri(string scope, string deploymentStackName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateGetAtScopeRequest(string scope, string deploymentStackName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a Deployment stack with a given name at specific scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DeploymentStackData>> GetAtScopeAsync(string scope, string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateGetAtScopeRequest(scope, deploymentStackName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeploymentStackData.DeserializeDeploymentStackData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DeploymentStackData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a Deployment stack with a given name at specific scope. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DeploymentStackData> GetAtScope(string scope, string deploymentStackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateGetAtScopeRequest(scope, deploymentStackName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeploymentStackData.DeserializeDeploymentStackData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DeploymentStackData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteAtScopeRequestUri(string scope, string deploymentStackName, UnmanageActionResourceMode? unmanageActionResources, UnmanageActionResourceGroupMode? unmanageActionResourceGroups, UnmanageActionManagementGroupMode? unmanageActionManagementGroups, bool? bypassStackOutOfSyncError)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            if (unmanageActionResources != null)
            {
                uri.AppendQuery("unmanageAction.Resources", unmanageActionResources.Value.ToString(), true);
            }
            if (unmanageActionResourceGroups != null)
            {
                uri.AppendQuery("unmanageAction.ResourceGroups", unmanageActionResourceGroups.Value.ToString(), true);
            }
            if (unmanageActionManagementGroups != null)
            {
                uri.AppendQuery("unmanageAction.ManagementGroups", unmanageActionManagementGroups.Value.ToString(), true);
            }
            if (bypassStackOutOfSyncError != null)
            {
                uri.AppendQuery("bypassStackOutOfSyncError", bypassStackOutOfSyncError.Value, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal Core.HttpMessage CreateDeleteAtScopeRequest(string scope, string deploymentStackName, UnmanageActionResourceMode? unmanageActionResources, UnmanageActionResourceGroupMode? unmanageActionResourceGroups, UnmanageActionManagementGroupMode? unmanageActionManagementGroups, bool? bypassStackOutOfSyncError)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(scope, false);
            uri.AppendPath("/providers/Microsoft.Resources/deploymentStacks/", false);
            uri.AppendPath(deploymentStackName, true);
            if (unmanageActionResources != null)
            {
                uri.AppendQuery("unmanageAction.Resources", unmanageActionResources.Value.ToString(), true);
            }
            if (unmanageActionResourceGroups != null)
            {
                uri.AppendQuery("unmanageAction.ResourceGroups", unmanageActionResourceGroups.Value.ToString(), true);
            }
            if (unmanageActionManagementGroups != null)
            {
                uri.AppendQuery("unmanageAction.ManagementGroups", unmanageActionManagementGroups.Value.ToString(), true);
            }
            if (bypassStackOutOfSyncError != null)
            {
                uri.AppendQuery("bypassStackOutOfSyncError", bypassStackOutOfSyncError.Value, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes a Deployment stack by name at specific scope. When operation completes, status code 200 returned without content. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="unmanageActionResources"> Flag to indicate delete rather than detach for unmanaged resources. </param>
        /// <param name="unmanageActionResourceGroups"> Flag to indicate delete rather than detach for unmanaged resource groups. </param>
        /// <param name="unmanageActionManagementGroups"> Flag to indicate delete rather than detach for unmanaged management groups. </param>
        /// <param name="bypassStackOutOfSyncError"> Flag to bypass service errors that indicate the stack resource list is not correctly synchronized. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAtScopeAsync(string scope, string deploymentStackName, UnmanageActionResourceMode? unmanageActionResources = null, UnmanageActionResourceGroupMode? unmanageActionResourceGroups = null, UnmanageActionManagementGroupMode? unmanageActionManagementGroups = null, bool? bypassStackOutOfSyncError = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateDeleteAtScopeRequest(scope, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes a Deployment stack by name at specific scope. When operation completes, status code 200 returned without content. </summary>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="deploymentStackName"> Name of the deployment stack. </param>
        /// <param name="unmanageActionResources"> Flag to indicate delete rather than detach for unmanaged resources. </param>
        /// <param name="unmanageActionResourceGroups"> Flag to indicate delete rather than detach for unmanaged resource groups. </param>
        /// <param name="unmanageActionManagementGroups"> Flag to indicate delete rather than detach for unmanaged management groups. </param>
        /// <param name="bypassStackOutOfSyncError"> Flag to bypass service errors that indicate the stack resource list is not correctly synchronized. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scope"/> or <paramref name="deploymentStackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="deploymentStackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response DeleteAtScope(string scope, string deploymentStackName, UnmanageActionResourceMode? unmanageActionResources = null, UnmanageActionResourceGroupMode? unmanageActionResourceGroups = null, UnmanageActionManagementGroupMode? unmanageActionManagementGroups = null, bool? bypassStackOutOfSyncError = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(scope, nameof(scope));
            Argument.AssertNotNullOrEmpty(deploymentStackName, nameof(deploymentStackName));

            using var message = CreateDeleteAtScopeRequest(scope, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListAtScopeNextPageRequestUri(string nextLink, string scope)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal Core.HttpMessage CreateListAtScopeNextPageRequest(string nextLink, string scope)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists all the Deployment stacks within the specified scope. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="scope"/> is null. </exception>
        public async Task<Response<DeploymentStackListResult>> ListAtScopeNextPageAsync(string nextLink, string scope, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(scope, nameof(scope));

            using var message = CreateListAtScopeNextPageRequest(nextLink, scope);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeploymentStackListResult.DeserializeDeploymentStackListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all the Deployment stacks within the specified scope. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="scope"> The resource scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="scope"/> is null. </exception>
        public Response<DeploymentStackListResult> ListAtScopeNextPage(string nextLink, string scope, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(scope, nameof(scope));

            using var message = CreateListAtScopeNextPageRequest(nextLink, scope);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeploymentStackListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeploymentStackListResult.DeserializeDeploymentStackListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
