// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class WhatIfPropertyChangeTypeExtensions
    {
        public static string ToSerialString(this WhatIfPropertyChangeType value) => value switch
        {
            WhatIfPropertyChangeType.Create => "Create",
            WhatIfPropertyChangeType.Delete => "Delete",
            WhatIfPropertyChangeType.Modify => "Modify",
            WhatIfPropertyChangeType.Array => "Array",
            WhatIfPropertyChangeType.NoEffect => "NoEffect",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WhatIfPropertyChangeType value.")
        };

        public static WhatIfPropertyChangeType ToWhatIfPropertyChangeType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Create")) return WhatIfPropertyChangeType.Create;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Delete")) return WhatIfPropertyChangeType.Delete;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Modify")) return WhatIfPropertyChangeType.Modify;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Array")) return WhatIfPropertyChangeType.Array;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NoEffect")) return WhatIfPropertyChangeType.NoEffect;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WhatIfPropertyChangeType value.");
        }
    }
}
