// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class WhatIfChangeTypeExtensions
    {
        public static string ToSerialString(this WhatIfChangeType value) => value switch
        {
            WhatIfChangeType.Create => "Create",
            WhatIfChangeType.Delete => "Delete",
            WhatIfChangeType.Ignore => "Ignore",
            WhatIfChangeType.Deploy => "Deploy",
            WhatIfChangeType.NoChange => "NoChange",
            WhatIfChangeType.Modify => "Modify",
            WhatIfChangeType.Unsupported => "Unsupported",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WhatIfChangeType value.")
        };

        public static WhatIfChangeType ToWhatIfChangeType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Create")) return WhatIfChangeType.Create;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Delete")) return WhatIfChangeType.Delete;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Ignore")) return WhatIfChangeType.Ignore;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deploy")) return WhatIfChangeType.Deploy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NoChange")) return WhatIfChangeType.NoChange;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Modify")) return WhatIfChangeType.Modify;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Unsupported")) return WhatIfChangeType.Unsupported;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WhatIfChangeType value.");
        }
    }
}
