// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The UnmanageActionResourceMode. </summary>
    public readonly partial struct UnmanageActionResourceMode : IEquatable<UnmanageActionResourceMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UnmanageActionResourceMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UnmanageActionResourceMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "delete";
        private const string DetachValue = "detach";

        /// <summary> delete. </summary>
        public static UnmanageActionResourceMode Delete { get; } = new UnmanageActionResourceMode(DeleteValue);
        /// <summary> detach. </summary>
        public static UnmanageActionResourceMode Detach { get; } = new UnmanageActionResourceMode(DetachValue);
        /// <summary> Determines if two <see cref="UnmanageActionResourceMode"/> values are the same. </summary>
        public static bool operator ==(UnmanageActionResourceMode left, UnmanageActionResourceMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UnmanageActionResourceMode"/> values are not the same. </summary>
        public static bool operator !=(UnmanageActionResourceMode left, UnmanageActionResourceMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UnmanageActionResourceMode"/>. </summary>
        public static implicit operator UnmanageActionResourceMode(string value) => new UnmanageActionResourceMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UnmanageActionResourceMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UnmanageActionResourceMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
