// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The UnmanageActionManagementGroupMode. </summary>
    public readonly partial struct UnmanageActionManagementGroupMode : IEquatable<UnmanageActionManagementGroupMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UnmanageActionManagementGroupMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UnmanageActionManagementGroupMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "delete";
        private const string DetachValue = "detach";

        /// <summary> delete. </summary>
        public static UnmanageActionManagementGroupMode Delete { get; } = new UnmanageActionManagementGroupMode(DeleteValue);
        /// <summary> detach. </summary>
        public static UnmanageActionManagementGroupMode Detach { get; } = new UnmanageActionManagementGroupMode(DetachValue);
        /// <summary> Determines if two <see cref="UnmanageActionManagementGroupMode"/> values are the same. </summary>
        public static bool operator ==(UnmanageActionManagementGroupMode left, UnmanageActionManagementGroupMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UnmanageActionManagementGroupMode"/> values are not the same. </summary>
        public static bool operator !=(UnmanageActionManagementGroupMode left, UnmanageActionManagementGroupMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UnmanageActionManagementGroupMode"/>. </summary>
        public static implicit operator UnmanageActionManagementGroupMode(string value) => new UnmanageActionManagementGroupMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UnmanageActionManagementGroupMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UnmanageActionManagementGroupMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
