// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> High-level information about a Template Spec version. </summary>
    public partial class TemplateSpecVersionInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TemplateSpecVersionInfo"/>. </summary>
        internal TemplateSpecVersionInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TemplateSpecVersionInfo"/>. </summary>
        /// <param name="description"> Template Spec version description. </param>
        /// <param name="timeCreated"> The timestamp of when the version was created. </param>
        /// <param name="timeModified"> The timestamp of when the version was last modified. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TemplateSpecVersionInfo(string description, DateTimeOffset? timeCreated, DateTimeOffset? timeModified, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            TimeCreated = timeCreated;
            TimeModified = timeModified;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Template Spec version description. </summary>
        [WirePath("description")]
        public string Description { get; }
        /// <summary> The timestamp of when the version was created. </summary>
        [WirePath("timeCreated")]
        public DateTimeOffset? TimeCreated { get; }
        /// <summary> The timestamp of when the version was last modified. </summary>
        [WirePath("timeModified")]
        public DateTimeOffset? TimeModified { get; }
    }
}
