// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Settings to use an existing storage account. Valid storage account kinds are: Storage, StorageV2 and FileStorage. </summary>
    public partial class ScriptStorageConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScriptStorageConfiguration"/>. </summary>
        public ScriptStorageConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScriptStorageConfiguration"/>. </summary>
        /// <param name="storageAccountName"> The storage account name. </param>
        /// <param name="storageAccountKey"> The storage account access key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScriptStorageConfiguration(string storageAccountName, string storageAccountKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccountName = storageAccountName;
            StorageAccountKey = storageAccountKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The storage account name. </summary>
        [WirePath("storageAccountName")]
        public string StorageAccountName { get; set; }
        /// <summary> The storage account access key. </summary>
        [WirePath("storageAccountKey")]
        public string StorageAccountKey { get; set; }
    }
}
