// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'. </summary>
    public readonly partial struct ScriptCleanupOptions : IEquatable<ScriptCleanupOptions>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptCleanupOptions"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptCleanupOptions(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlwaysValue = "Always";
        private const string OnSuccessValue = "OnSuccess";
        private const string OnExpirationValue = "OnExpiration";

        /// <summary> Always. </summary>
        public static ScriptCleanupOptions Always { get; } = new ScriptCleanupOptions(AlwaysValue);
        /// <summary> OnSuccess. </summary>
        public static ScriptCleanupOptions OnSuccess { get; } = new ScriptCleanupOptions(OnSuccessValue);
        /// <summary> OnExpiration. </summary>
        public static ScriptCleanupOptions OnExpiration { get; } = new ScriptCleanupOptions(OnExpirationValue);
        /// <summary> Determines if two <see cref="ScriptCleanupOptions"/> values are the same. </summary>
        public static bool operator ==(ScriptCleanupOptions left, ScriptCleanupOptions right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptCleanupOptions"/> values are not the same. </summary>
        public static bool operator !=(ScriptCleanupOptions left, ScriptCleanupOptions right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptCleanupOptions"/>. </summary>
        public static implicit operator ScriptCleanupOptions(string value) => new ScriptCleanupOptions(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptCleanupOptions other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptCleanupOptions other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
